"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const lodash_1 = __importDefault(require("lodash"));
const pagination_1 = require("../../components/pagination");
const customer_master_model_1 = __importDefault(require("../../model/admin/customer-management/customer-master-model"));
const items_master_model_1 = __importDefault(require("../../model/admin/inventory-management/items/items-master-model"));
const job_order_assignment_history_model_1 = __importDefault(require("../../model/admin/job-order/job-order-assignment-history-model"));
const job_order_details_model_1 = __importDefault(require("../../model/admin/job-order/job-order-details-model"));
const job_order_master_model_1 = __importDefault(require("../../model/admin/job-order/job-order-master-model"));
const admin_user_model_1 = __importDefault(require("../../model/admin/staff-management/admin-user-model"));
class TechnicianJobAssignService {
    async findAll(options) {
        const { query, skip, limit, sort } = (0, pagination_1.pagination)(options.query || {}, options);
        const defaultSort = { createdAt: -1 };
        let finalSort = sort || defaultSort;
        const sortKeys = Object.keys(finalSort);
        if (sortKeys.length === 0) {
            finalSort = defaultSort;
        }
        let pipeline = [
            {
                $lookup: {
                    from: admin_user_model_1.default.collection.name,
                    localField: 'technicianId',
                    foreignField: '_id',
                    as: 'technicianDetails',
                }
            },
            { $unwind: { path: '$technicianDetails', preserveNullAndEmptyArrays: true } },
            {
                $lookup: {
                    from: job_order_master_model_1.default.collection.name,
                    localField: 'jobMasterId',
                    foreignField: '_id',
                    as: 'jobOrderMasterDetails',
                }
            },
            { $unwind: { path: '$jobOrderMasterDetails', preserveNullAndEmptyArrays: true } },
            {
                $lookup: {
                    from: job_order_details_model_1.default.collection.name,
                    localField: 'jobOrderDetailId',
                    foreignField: '_id',
                    as: 'jobOrderDetails',
                }
            },
            { $unwind: { path: '$jobOrderDetails', preserveNullAndEmptyArrays: true } },
            {
                $lookup: {
                    from: items_master_model_1.default.collection.name,
                    localField: 'jobOrderDetails.itemMasterId',
                    foreignField: '_id',
                    as: 'itemMaster',
                }
            },
            { $unwind: { path: '$itemMaster', preserveNullAndEmptyArrays: true } },
            {
                $lookup: {
                    from: customer_master_model_1.default.collection.name,
                    localField: 'jobOrderMasterDetails.customerId',
                    foreignField: '_id',
                    as: 'customerDetails',
                }
            },
            { $unwind: { path: '$customerDetails', preserveNullAndEmptyArrays: true } },
            {
                $project: {
                    taskId: 1,
                    jobMasterId: 1,
                    jobOrderDetailId: 1,
                    technicianId: 1,
                    reassignedFromId: 1,
                    taskTitle: 1,
                    reason: 1,
                    description: 1,
                    priority: 1,
                    reassigned: 1,
                    assignedAt: 1,
                    startDate: 1,
                    endDate: 1,
                    taskStartTime: 1,
                    taskEndTime: 1,
                    technicianStatus: 1,
                    technicianStatusAt: 1,
                    reassignedFromIdAt: 1,
                    createdBy: 1,
                    createdAt: 1,
                    updatedAt: 1,
                    itemMaster: 1,
                    'technicianDetails._id': 1,
                    'technicianDetails.userTitle': 1,
                    'technicianDetails.userCode': 1,
                    'technicianDetails.userEmail': 1,
                    'technicianDetails.userPhoneNumber': 1,
                    'technicianDetails.status': 1,
                    'jobOrderMasterDetails._id': 1,
                    'jobOrderMasterDetails.customerId': 1,
                    'jobOrderMasterDetails.jobId': 1,
                    'jobOrderMasterDetails.jobTotalQuantity': 1,
                    'jobOrderMasterDetails.jobTotalAmount': 1,
                    'jobOrderMasterDetails.jobOrderStatus': 1,
                    'jobOrderMasterDetails.jobOrderStatusAt': 1,
                    'jobOrderDetails._id': 1,
                    'jobOrderDetails.jobMasterId': 1,
                    'jobOrderDetails.categoryId': 1,
                    'jobOrderDetails.branchId': 1,
                    'jobOrderDetails.itemMasterId': 1,
                    'jobOrderDetails.assignedToId': 1,
                    'jobOrderDetails.complaintId': 1,
                    'jobOrderDetails.vendorId': 1,
                    'jobOrderDetails.conditionId': 1,
                    'jobOrderDetails.transferBranchId': 1,
                    'jobOrderDetails.totalQuantity': 1,
                    'jobOrderDetails.totalAmount': 1,
                    'jobOrderDetails.priority': 1,
                    'jobOrderDetails.technicianStatus': 1,
                    'jobOrderDetails.technicianStatusAt': 1,
                    'customerDetails._id': 1,
                    'customerDetails.customerTitle': 1,
                    'customerDetails.customerEmail': 1,
                    'customerDetails.customerPhoneNumber': 1,
                    'customerDetails.customerCountryCode': 1,
                }
            },
        ];
        const isQueryValid = lodash_1.default.isObject(query) && !lodash_1.default.isEmpty(query);
        const isSortValid = lodash_1.default.isObject(finalSort) && !lodash_1.default.isEmpty(finalSort);
        const isSkipValid = lodash_1.default.isNumber(skip) && skip >= 0;
        const isLimitValid = lodash_1.default.isNumber(limit) && limit > 0;
        if (isQueryValid) {
            pipeline.push({ $match: query });
        }
        if (isSortValid && isSkipValid && isLimitValid) {
            pipeline.push({
                $facet: {
                    data: [
                        { $sort: finalSort },
                        { $skip: skip },
                        { $limit: limit }
                    ],
                    totalCount: [
                        { $count: "total" }
                    ]
                }
            });
        }
        try {
            return await job_order_assignment_history_model_1.default.aggregate(pipeline).exec();
        }
        catch (error) {
            console.error('Error in aggregation query:', error);
            throw error;
        }
    }
}
exports.default = new TechnicianJobAssignService();
