"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.extractAllCategoryIds = extractAllCategoryIds;
const lodash_1 = require("lodash");
function extractAllCategoryIds(categories) {
    return (0, lodash_1.flattenDeep)(categories.map((category) => {
        const parentIds = category.parentCategories
            ? extractAllCategoryIds(category.parentCategories)
            : [];
        const childIds = category.childCategories
            ? extractAllCategoryIds(category.childCategories)
            : [];
        return [category._id, ...parentIds, ...childIds];
    }));
}
