"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerProject = exports.customerLookup = void 0;
const collections_1 = require("../../../../constants/collections");
const customerLookup = (match) => {
    return {
        $lookup: {
            from: `${collections_1.collections.customerManagement.customerMaster}`,
            localField: 'customerId',
            foreignField: '_id',
            as: 'customer',
            pipeline: [
                ...(match ? [{ $match: match }] : []),
            ]
        }
    };
};
exports.customerLookup = customerLookup;
exports.customerProject = [
    { $unwind: { path: "$branch", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$country", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$state", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$city", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            customerTitleType: 1,
            customerType: 1,
            customerTitle: 1,
            customerCode: 1,
            customerEmail: 1,
            customerPhoneNumber: 1,
            customerCountryCode: 1,
            customerAlternativePhoneNumber: 1,
            customerAlternativeCountryCode: 1,
            customerPassword: 1,
            customerImageUrl: 1,
            dob: 1,
            referralSource: 1,
            address1: 1,
            address2: 1,
            status: 1,
            createdBy: 1,
            createdAt: 1,
            updatedAt: 1,
            "branch": {
                "_id": 1,
                "branchTitle": 1,
                "branchCode": 1,
                "slug": 1,
            },
            country: {
                _id: 1,
                countryTitle: 1,
            },
            state: {
                _id: 1,
                stateTitle: 1,
            },
            city: {
                _id: 1,
                cityTitle: 1,
            },
        }
    }
];
