"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.categoriesWithChildrenInArrayAggregation = exports.categoryProject = exports.parentCategoryLookup = exports.subCategoriesLookup = exports.categoryLookup = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const collections_1 = require("../../../../constants/collections");
exports.categoryLookup = {
    $lookup: {
        from: `${collections_1.collections.inventoryManagement.categories}`,
        localField: 'categoryId',
        foreignField: '_id',
        as: 'category'
    }
};
exports.subCategoriesLookup = [
    {
        $lookup: {
            from: `${collections_1.collections.inventoryManagement.categories}`,
            localField: 'category.parentCategory',
            foreignField: '_id',
            as: 'category.subCategories'
        }
    },
    {
        $lookup: {
            from: "categories",
            localField: "categoryId",
            foreignField: "_id",
            as: "category",
        },
    },
    { $unwind: { path: "$category", preserveNullAndEmptyArrays: true } },
    {
        $lookup: {
            from: "categories",
            localField: "category._id",
            foreignField: "parentCategory",
            as: "category.subCategories",
        },
    },
    { $unwind: { path: "$category.subCategories", preserveNullAndEmptyArrays: true } },
    {
        $lookup: {
            from: "categories",
            localField: "category.subCategories._id",
            foreignField: "parentCategory",
            as: "category.subCategories.subCategories",
        },
    },
    { $unwind: { path: "$category.subCategories.subCategories", preserveNullAndEmptyArrays: true } },
];
exports.parentCategoryLookup = {
    $lookup: {
        from: `${collections_1.collections.inventoryManagement.categories}`,
        localField: 'category.parentCategory',
        foreignField: '_id',
        as: 'subCategories'
    }
};
// export const parentCategoryLookup = {
//     $lookup: {
//         from: `${collections.inventoryManagement.categories}`,
//         localField: '_id',
//         foreignField: 'parentCategory',
//         as: 'subCategories',
//         pipeline: [
//             {
//                 $lookup: {
//                     from: `${collections.inventoryManagement.categories}`,
//                     localField: '_id',
//                     foreignField: 'parentCategory',
//                     as: 'subCategories',
//                 },
//             },
//         ],
//     }
// }
exports.categoryProject = {
    $project: {
        _id: 1,
        categoryTitle: 1,
        slug: 1,
        description: 1,
        categoryImageUrl: 1,
        parentCategory: 1,
        additionalFields: 1,
        level: 1,
        lastLevel: 1,
        categoryType: 1,
        serviceSettings: 1,
        status: 1,
        createdAt: 1,
        subCategories: {
            $ifNull: ['$subCategories', []]
        },
    }
};
const categoriesWithChildrenInArrayAggregation = (uniqueCategoryIds, query) => {
    return [
        {
            $match: query ? query : { _id: { $in: uniqueCategoryIds.map(id => new mongoose_1.default.Types.ObjectId(id)) } },
        },
        {
            $graphLookup: {
                from: `${collections_1.collections.inventoryManagement.categories}`,
                startWith: "$_id",
                connectFromField: "_id",
                connectToField: "parentCategory",
                as: "parentCategories",
                depthField: "level",
            },
        },
        {
            $addFields: {
                parentCategories: {
                    $map: {
                        input: { $ifNull: ["$parentCategories", []] },
                        as: "category",
                        in: {
                            _id: "$$category._id",
                            categoryTitle: "$$category.categoryTitle",
                            slug: "$$category.slug",
                            parentCategory: "$$category.parentCategory",
                            level: "$$category.level",
                            childCategories: {
                                $map: {
                                    input: {
                                        $filter: {
                                            input: { $ifNull: ["$parentCategories", []] },
                                            as: "subCategory",
                                            cond: {
                                                $and: [
                                                    { $eq: ["$$subCategory.parentCategory", "$$category._id"] },
                                                    { $gt: ["$$subCategory.level", "$$category.level"] },
                                                ],
                                            },
                                        },
                                    },
                                    as: "child",
                                    in: {
                                        _id: "$$child._id",
                                        categoryTitle: "$$child.categoryTitle",
                                        slug: "$$child.slug",
                                        parentCategory: "$$child.parentCategory",
                                        level: "$$child.level",
                                    },
                                },
                            },
                        },
                    },
                },
            },
        },
        {
            $project: {
                _id: 1,
                categoryTitle: 1,
                slug: 1,
                level: 1,
                parentCategory: 1,
                parentCategories: 1,
            },
        },
    ];
};
exports.categoriesWithChildrenInArrayAggregation = categoriesWithChildrenInArrayAggregation;
