"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.complaintProject = exports.complaintLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.complaintLookup = {
    $lookup: {
        from: `${collections_1.collections.inventoryManagement.complaint}`,
        localField: 'complaintId',
        foreignField: '_id',
        as: 'complaint'
    }
};
exports.complaintProject = [
    { $unwind: { path: "$category", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            "_id": 1,
            "complaintTitle": 1,
            "slug": 1,
            "description": 1,
            "status": 1,
            "createdBy": 1,
            "createdAt": 1,
            "updatedAt": 1,
            "category": {
                "_id": 1,
                "categoryTitle": 1,
                "parentCategory": 1,
                "description": 1,
                "categoryImageUrl": 1,
                "categoryType": 1,
                "level": 1,
                "slug": 1,
            }
        }
    }
];
