"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.itemDetailsProject = exports.itemMasterProject = exports.itemMasterAttributes = exports.itemMasterWithDetail = exports.itemStockInventoryLookup = exports.itemMasterLookup = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const collections_1 = require("../../../../constants/collections");
const lodash_1 = require("lodash");
exports.itemMasterLookup = {
    $lookup: {
        from: `${collections_1.collections.inventoryManagement.items.itemsMaster}`,
        localField: 'itemMasterId',
        foreignField: '_id',
        as: 'itemMaster'
    }
};
const itemStockInventoryLookup = (branchStockQuery, getstockbranch = '0') => {
    const pipeline = [];
    if (!(0, lodash_1.isEmpty)(branchStockQuery)) {
        pipeline.push({ $match: branchStockQuery });
        if (getstockbranch === '1') {
            pipeline.push({
                $lookup: {
                    from: `${collections_1.collections.operations.branches}`,
                    localField: 'branchId',
                    foreignField: '_id',
                    as: 'branch'
                }
            });
            pipeline.push({ $unwind: { path: '$branch', preserveNullAndEmptyArrays: true } });
        }
    }
    return [
        {
            $lookup: {
                from: `${collections_1.collections.inventoryManagement.items.stockInventory}`,
                localField: '_id',
                foreignField: 'itemId',
                as: 'stockInventory',
                pipeline: pipeline.length > 0 ? pipeline : undefined
            }
        }
    ];
};
exports.itemStockInventoryLookup = itemStockInventoryLookup;
// export const itemMasterAttributes = [
//     {
//         $lookup: {
//             from: collections.inventoryManagement.items.itemMasterAttributes,
//             localField: '_id',
//             foreignField: 'itemMasterId',
//             as: 'attributes',
//         }
//     },
//     {
//         $unwind: {
//             path: '$attributes',
//             preserveNullAndEmptyArrays: true
//         }
//     },
//     {
//         $lookup: {
//             from: collections.inventoryManagement.attributeMaster,
//             localField: '_id',
//             foreignField: 'attributeId',
//             as: 'attributes.attributeDetails',
//         }
//     },
//     {
//         $unwind: {
//             path: '$attributes.attributeDetails',
//             preserveNullAndEmptyArrays: true
//         }
//     }
// ];
const itemMasterWithDetail = (branchId) => {
    return {
        $lookup: {
            from: collections_1.collections.inventoryManagement.items.itemsDetails,
            localField: "_id",
            foreignField: "itemMasterId",
            as: "itemsDetails",
            pipeline: [
                {
                    $lookup: {
                        from: collections_1.collections.inventoryManagement.items.stockInventory,
                        let: { itemId: "$_id" },
                        as: "stockInventory",
                        pipeline: [
                            {
                                $match: {
                                    $expr: {
                                        $and: [
                                            { $eq: ["$itemId", "$$itemId"] },
                                            ...(branchId ? [{ $eq: ["$branchId", new mongoose_1.default.Types.ObjectId(branchId)] }] : [])
                                        ]
                                    }
                                }
                            },
                            {
                                $lookup: {
                                    from: collections_1.collections.operations.branches,
                                    localField: "branchId",
                                    foreignField: "_id",
                                    as: "branch",
                                }
                            },
                            {
                                $unwind: {
                                    path: "$branch",
                                    preserveNullAndEmptyArrays: false
                                }
                            }
                        ],
                    }
                },
                {
                    $unwind: {
                        path: "$stockInventory",
                        preserveNullAndEmptyArrays: false
                    }
                }
            ]
        }
    };
};
exports.itemMasterWithDetail = itemMasterWithDetail;
exports.itemMasterAttributes = [
    {
        $lookup: {
            from: collections_1.collections.inventoryManagement.items.itemMasterAttributes,
            localField: '_id',
            foreignField: 'itemMasterId',
            as: 'attributes',
            pipeline: [
                {
                    $lookup: {
                        from: `${collections_1.collections.inventoryManagement.attributeDetail}`,
                        localField: 'attributeDetailId',
                        foreignField: '_id',
                        as: 'attributeDetail'
                    }
                },
                {
                    $unwind: "$attributeDetail"
                },
                {
                    $lookup: {
                        from: `${collections_1.collections.inventoryManagement.attributeMaster}`,
                        localField: 'attributeId',
                        foreignField: '_id',
                        as: 'attribute'
                    }
                },
                {
                    $unwind: "$attribute"
                },
                {
                    $project: {
                        _id: 1,
                        itemMasterId: 1,
                        attribute: {
                            _id: '$attribute._id',
                            attributeTitle: '$attribute.attributeTitle',
                            slug: '$attribute.slug',
                            attributeType: '$attribute.attributeType',
                        },
                        attributeDetail: {
                            _id: '$attributeDetail._id',
                            attributeId: '$attributeDetail.attributeId',
                            itemName: '$attributeDetail.itemName',
                            itemValue: '$attributeDetail.itemValue',
                        }
                    }
                }
            ]
        }
    },
];
exports.itemMasterProject = [
    {
        $project: {
            "_id": 1,
            "itemMasterTitle": 1,
            "slug": 1,
            "itemMasterCode": 1,
            bomMasterQuantity: 1,
            bomMasterOldQuantity: 1,
            itemMasterPrice: 1,
            "itemMasterDescription": 1,
            "itemMasterImageUrl": 1,
            "category": {
                _id: 1,
                categoryTitle: 1,
                slug: 1,
                parentCategory: 1,
                description: 1,
                categoryImageUrl: 1,
                level: 1,
            },
            "attributes": 1,
            "status": 1,
            "createdBy": 1,
        }
    }
];
exports.itemDetailsProject = [
    {
        $project: {
            _id: 1,
            itemTitle: 1,
            slug: 1,
            itemCode: 1,
            itemType: 1,
            itemDescription: 1,
            itemImageUrl: 1,
            itemPrice: 1,
            itemTypeQuantity: 1,
            totalItemStock: 1,
            barCode: 1,
            hsnCode: 1,
            unit: 1,
            measurements: 1,
            qualityType: 1,
            status: 1,
            itemMaster: {
                "_id": 1,
                "itemMasterTitle": 1,
                "slug": 1,
                "itemMasterCode": 1,
                "itemMasterDescription": 1,
                bomMasterQuantity: 1,
                bomMasterOldQuantity: 1,
                itemMasterPrice: 1,
                "itemMasterImageUrl": 1,
                "status": 1,
            },
            stockInventory: 1,
            warranty: {
                warrantyTitle: 1,
                slug: 1,
                warrantyCode: 1,
                warrantyPeriod: 1,
                termsAndConditions: 1,
                coverageDetails: 1,
            }
        }
    }
];
