"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.jobOrderDetailsProject = exports.jobOrderProject = exports.jobOrderItemDetailLookup = exports.itemDetailLookup = void 0;
const collections_1 = require("../../../../constants/collections");
const itemDetailLookup = (foreignField = 'itemMasterId') => {
    return {
        $lookup: {
            from: collections_1.collections.inventoryManagement.items.itemsDetails,
            localField: '_id',
            foreignField: foreignField,
            as: 'itemDetail',
        }
    };
};
exports.itemDetailLookup = itemDetailLookup;
const jobOrderItemDetailLookup = (foreignField = 'itemMasterId') => {
    return {
        $lookup: {
            from: collections_1.collections.inventoryManagement.items.itemsDetails,
            localField: '_id',
            foreignField: foreignField,
            as: 'itemDetail',
        }
    };
};
exports.jobOrderItemDetailLookup = jobOrderItemDetailLookup;
const jobOrderProject = (options) => {
    const { simple = '1', jobdetails = '0', getcustomer = '0', getbranch = '0' } = options;
    const projectFields = {
        _id: 1,
        jobId: 1,
        createdBranchId: 1,
        customerId: 1,
        jobTotalQuantity: 1,
        jobSubTotalAmount: 1,
        jobBalanceAmount: 1,
        jobTotalAmount: 1,
        costItems: 1,
        priority: 1,
        jobOrderStatus: 1,
        jobOrderStatusAt: 1,
        createdBy: 1,
        createdAt: 1,
        updatedAt: 1,
    };
    if (jobdetails === '1') {
        projectFields['jobOrderDetail'] = {
            _id: 1,
            jobMasterId: 1,
            itemMasterId: 1,
            branchId: 1,
            assignedToId: 1,
            parentCategoryId: 1,
            categoryId: 1,
            complaintId: 1,
            vendorId: 1,
            conditionId: 1,
            costCenterId: 1,
            paymentTermId: 1,
            transferBranchId: 1,
            totalQuantity: 1,
            subtotalAmount: 1,
            balanceAmount: 1,
            totalAmount: 1,
            technicianStatus: 1,
            vendorStatus: 1,
            technicianStatusAt: 1,
            transferBranchStatus: 1,
            transferBranchStatusAt: 1,
            transferReason: 1,
            transferBranchAt: 1,
            vendorStatusAt: 1,
            driverId: 1,
            serviceType: 1,
            driverHistoryStatus: 1,
            driverHistoryStatusAt: 1,
            dueDate: 1,
            additionalFields: 1,
        };
    }
    if (getcustomer === '1') {
        projectFields['customer'] = {
            _id: 1,
            branchId: 1,
            customerType: 1,
            customerTitleType: 1,
            customerTitle: 1,
            customerCode: 1,
            customerEmail: 1,
            customerPhoneNumber: 1,
            customerCountryCode: 1,
            customerAlternativeCountryCode: 1,
            customerAlternativePhoneNumber: 1,
            dob: 1,
            referralSource: 1,
            address1: 1,
            address2: 1,
        };
    }
    if (getbranch === '1') {
        projectFields['branch'] = {
            _id: 1,
            branchTitle: 1,
            branchCode: 1,
            slug: 1,
        };
    }
    return { $project: projectFields };
};
exports.jobOrderProject = jobOrderProject;
const jobOrderDetailsProject = (options) => {
    const { getjobOrder = '0', getcategory = '0', getcomplaint = '0', getbranch = '0', gettransferbranch = '0', getgalleryimages = '0', getvendor = "0" } = options;
    const projectFields = {
        _id: 1,
        itemMasterId: 1,
        assignedToId: 1,
        parentCategoryId: 1,
        categoryId: 1,
        complaintId: 1,
        transferBranchId: 1,
        jobDetailNumber: 1,
        totalQuantity: 1,
        subtotalAmount: 1,
        balanceAmount: 1,
        totalAmount: 1,
        orderItems: 1,
        costItems: 1,
        itemMasterAttributes: 1,
        serialNumber: 1,
        customerSignature: 1,
        customerComments: 1,
        serviceType: 1,
        remarks: 1,
        technicianStatus: 1,
        serviceStatus: 1,
        serviceStatusAt: 1,
        serviceAssignedAt: 1,
        serviceCanceledAt: 1,
        serviceCompletedAt: 1,
        serviceReopenAt: 1,
        serviceClosedAt: 1,
        createdAt: 1,
        updatedAt: 1,
        itemMaster: 1,
        jobordergalleryimages: 1,
        vendorAssignRemarks: 1,
        vendorNotes: 1,
        vendorStatus: 1,
        vendorStatusAt: 1,
        transferBranchStatus: 1,
        transferBranchStatusAt: 1,
        transferReason: 1,
        transferBranchAt: 1,
        driverId: 1,
        historyStatus: 1,
        historyStatusAt: 1,
        driverHistoryStatus: 1,
        driverHistoryStatusAt: 1,
        dueDate: 1,
        additionalFields: 1
    };
    if (getjobOrder === '1') {
        projectFields['jobOrder'] = {
            _id: 1,
            customerId: 1,
            createdBranchId: 1,
            jobId: 1,
            jobTotalQuantity: 1,
            jobSubTotalAmount: 1,
            jobBalanceAmount: 1,
            jobTotalAmount: 1,
            costItems: 1,
            jobOrderStatus: 1,
            jobOrderStatusAt: 1,
            customer: 1
        };
    }
    if (getcategory === '1') {
        projectFields['category'] = {
            '_id': 1,
            'categoryTitle': 1,
            'parentCategory': 1,
            'slug': 1,
        };
    }
    if (getbranch === '1') {
        projectFields['branch'] = {
            _id: 1,
            branchTitle: 1,
            branchCode: 1,
            slug: 1,
        };
    }
    if (gettransferbranch === '1') {
        projectFields['transferBranch'] = {
            _id: 1,
            branchTitle: 1,
            branchCode: 1,
            slug: 1,
        };
    }
    if (getvendor === '1') {
        projectFields['vendor'] = {
            '_id': 1,
            'vendorTitle': 1,
            'slug': 1,
            'vendorCode': 1,
            'contactName': 1,
            'contactEmail': 1,
            'contactPhone': 1,
            'address': 1,
            'city': 1,
            'country': 1,
            'postalCode': 1,
            'vendorType': 1,
            'notes': 1,
        };
    }
    if (getcomplaint === '1') {
        projectFields['complaint'] = {
            '_id': 1,
            'complaintTitle': 1,
            'slug': 1,
            'categoryId': 1,
        };
    }
    // if (getgalleryimages === '1') {
    //     projectFields['getgalleryimages'] = {
    //         '_id': 1,
    //         'jobOrderMasterId': 1,
    //         'jobOrderDetailId': 1,
    //         'galleryImageUrl': 1,
    //         'type': 1,
    //     };
    // }
    return { $project: projectFields };
};
exports.jobOrderDetailsProject = jobOrderDetailsProject;
