"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.warehouseProject = exports.warehouseLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.warehouseLookup = {
    $lookup: {
        from: `${collections_1.collections.operations.warehouses}`,
        localField: 'warehouseId',
        foreignField: '_id',
        as: 'warehouse'
    }
};
exports.warehouseProject = [
    { $unwind: { path: "$branch", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            "_id": 1,
            "warehouseTitle": 1,
            "slug": 1,
            "warehouseCode": 1,
            "status": 1,
            "createdBy": 1,
            "createdAt": 1,
            "updatedAt": 1,
            "__v": 1,
            "branch": {
                "_id": 1,
                "branchTitle": 1,
                "branchCode": 1,
                "slug": 1,
            }
        }
    }
];
