"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.conditionProject = exports.conditionLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.conditionLookup = {
    $lookup: {
        from: `${collections_1.collections.other.conditions}`,
        localField: 'conditionId',
        foreignField: '_id',
        as: 'condition'
    }
};
exports.conditionProject = [
    { $unwind: { path: "$category", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            "_id": 1,
            "conditionTitle": 1,
            "slug": 1,
            "description": 1,
            "status": 1,
            "createdBy": 1,
            "createdAt": 1,
            "updatedAt": 1,
            "category": {
                "_id": 1,
                "categoryTitle": 1,
                "parentCategory": 1,
                "description": 1,
                "categoryImageUrl": 1,
                "categoryType": 1,
                "level": 1,
                "slug": 1,
            }
        }
    }
];
