"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerAccessoriesProject = exports.customerAccessoriesLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.customerAccessoriesLookup = {
    $lookup: {
        from: `${collections_1.collections.other.customerAccessories}`,
        localField: 'customerAccessoryId',
        foreignField: '_id',
        as: 'customerAccessory'
    }
};
exports.customerAccessoriesProject = [
    { $unwind: { path: "$category", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            "_id": 1,
            "customerAccessoryTitle": 1,
            "slug": 1,
            "description": 1,
            "status": 1,
            "createdBy": 1,
            "createdAt": 1,
            "updatedAt": 1,
            "category": {
                "_id": 1,
                "categoryTitle": 1,
                "parentCategory": 1,
                "description": 1,
                "categoryImageUrl": 1,
                "categoryType": 1,
                "level": 1,
                "slug": 1,
            }
        }
    }
];
