"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.serviceStatusProject = exports.serviceStatusLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.serviceStatusLookup = {
    $lookup: {
        from: `${collections_1.collections.other.serviceStatuses}`,
        localField: 'serviceStatusId',
        foreignField: '_id',
        as: 'serviceStatus'
    }
};
exports.serviceStatusProject = [
    { $unwind: { path: "$category", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            "_id": 1,
            "serviceStatusTitle": 1,
            "slug": 1,
            "description": 1,
            "status": 1,
            "createdBy": 1,
            "createdAt": 1,
            "updatedAt": 1,
            "category": {
                "_id": 1,
                "categoryTitle": 1,
                "parentCategory": 1,
                "description": 1,
                "categoryImageUrl": 1,
                "categoryType": 1,
                "level": 1,
                "slug": 1,
            }
        }
    }
];
