"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.attributeProject = exports.attributeDetailsLookup = exports.attributeMasterLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.attributeMasterLookup = {
    $lookup: {
        from: `${collections_1.collections.servicesManagement.attributeMaster}`,
        localField: '_id',
        foreignField: 'attributeId',
        as: 'attribute'
    }
};
exports.attributeDetailsLookup = {
    $lookup: {
        from: `${collections_1.collections.servicesManagement.attributeDetail}`,
        localField: '_id',
        foreignField: 'attributeId',
        as: 'attributeValues'
    }
};
exports.attributeProject = {
    $project: {
        _id: 1,
        attributeTitle: 1,
        slug: 1,
        attributeType: 1,
        status: 1,
        createdAt: 1,
        attributeValues: {
            $ifNull: ['$attributeValues', []]
        },
    }
};
