"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.categoryProject = exports.parentCategoryLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.parentCategoryLookup = {
    $lookup: {
        from: `${collections_1.collections.servicesManagement.categories}`,
        localField: '_id',
        foreignField: 'parentCategory',
        as: 'subCategories',
        pipeline: [
            {
                $lookup: {
                    from: `${collections_1.collections.servicesManagement.categories}`,
                    localField: '_id',
                    foreignField: 'parentCategory',
                    as: 'subCategories',
                },
            },
        ],
    }
};
exports.categoryProject = {
    $project: {
        _id: 1,
        categoryTitle: 1,
        slug: 1,
        description: 1,
        categoryImageUrl: 1,
        parentCategory: 1,
        level: 1,
        status: 1,
        createdAt: 1,
        subCategories: {
            $ifNull: ['$subCategories', []]
        },
    }
};
