"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userProject = exports.userLookup = void 0;
const collections_1 = require("../../../../constants/collections");
exports.userLookup = {
    $lookup: {
        from: `${collections_1.collections.staffManagement.adminUsers}`,
        localField: 'userId',
        foreignField: '_id',
        as: 'user'
    }
};
exports.userProject = [
    { $unwind: { path: "$branch", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$designation", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$department", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$country", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$state", preserveNullAndEmptyArrays: true } },
    { $unwind: { path: "$city", preserveNullAndEmptyArrays: true } },
    {
        $project: {
            userTitle: 1,
            userCode: 1,
            userEmail: 1,
            userPhoneNumber: 1,
            userPassword: 1,
            userImageUrl: 1,
            status: 1,
            createdBy: 1,
            createdAt: 1,
            updatedAt: 1,
            designation: {
                _id: 1,
                designationTitle: 1,
                designationCode: 1,
                slug: 1
            },
            department: {
                _id: 1,
                departmentTitle: 1,
                departmentCode: 1
            },
            "branch": {
                "_id": 1,
                "branchTitle": 1,
                "branchCode": 1,
                "slug": 1,
            },
            country: {
                _id: 1,
                countryTitle: 1,
            },
            state: {
                _id: 1,
                stateTitle: 1,
            },
            city: {
                _id: 1,
                cityTitle: 1,
            },
        }
    }
];
