"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.citiesLookup = exports.statesLookup = exports.countriesLookup = void 0;
const collections_1 = require("../../../constants/collections");
exports.countriesLookup = {
    $lookup: {
        from: `${collections_1.collections.general.countries}`,
        localField: 'countryId',
        foreignField: '_id',
        as: 'country'
    }
};
exports.statesLookup = {
    $lookup: {
        from: `${collections_1.collections.general.states}`,
        localField: 'stateId',
        foreignField: '_id',
        as: 'state'
    }
};
exports.citiesLookup = {
    $lookup: {
        from: `${collections_1.collections.general.cities}`,
        localField: 'cityId',
        foreignField: '_id',
        as: 'city'
    }
};
