"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerSchema = void 0;
const zod_1 = require("zod");
const countries_1 = require("../../../../constants/countries");
const customer_1 = require("../../../../constants/admin/customer");
exports.customerSchema = zod_1.z.object({
    countryId: zod_1.z.string().optional(),
    stateId: zod_1.z.string().optional(),
    cityId: zod_1.z.string().optional(),
    customerType: zod_1.z.enum([customer_1.customerTypes[0], customer_1.customerTypes[1]], { required_error: 'Customer type is required' }).default(customer_1.customerTypes[0]),
    customerTitle: zod_1.z.string({ required_error: 'Customer title is required', }).min(2, 'Customer title is should be 2 chars minimum'),
    customerTitleType: zod_1.z.enum([customer_1.customerTitleTypes[0], customer_1.customerTitleTypes[1]], { required_error: 'Title is required' }).default(customer_1.customerTitleTypes[0]),
    customerEmail: zod_1.z.string({ required_error: 'Email is required', }).email('Please provide a valid email address'),
    customerPhoneNumber: zod_1.z.string({ required_error: 'Phone number is required', }),
    customerCountryCode: zod_1.z.string({ required_error: 'Country code is required' })
        .default(countries_1.countries.find((country) => country.code === 'AE')?.phone || '971'),
    customerAlternativePhoneNumber: zod_1.z.string().optional(),
    customerAlternativeCountryCode: zod_1.z.string().optional(),
    customerPassword: zod_1.z.string().optional(),
    dob: zod_1.z.string().optional(),
    address1: zod_1.z.string().optional(),
    referralSource: zod_1.z.string().optional(), // eg insta facebook
    address2: zod_1.z.string().optional(),
}).nonstrict();
