"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.categoryStatusSchema = exports.categorySchema = exports.serviceSettings = void 0;
const zod_1 = require("zod");
exports.serviceSettings = zod_1.z.object({
    isComplaints: zod_1.z.enum(['1', '2'], { required_error: 'IsComplaints is required' }).optional(),
    customerDetails: zod_1.z.object({
        isConditions: zod_1.z.enum(['1', '2'], { required_error: 'IsConditions is required' }).optional(),
        isAttribute: zod_1.z.enum(['1', '2'], { required_error: 'isAttribute is required' }).optional(),
        isSerialAndImei: zod_1.z.enum(['1', '2'], { required_error: 'isSerialAndImei is required' }).optional(),
        isAccessoriesAlongWithItem: zod_1.z.enum(['1', '2'], { required_error: 'isAccessoriesAlongWithItem is required' }).optional(),
        isRemarks: zod_1.z.enum(['1', '2'], { required_error: 'isRemarks is required' }).optional(),
        isUploadCustomerItemPhotos: zod_1.z.enum(['1', '2'], { required_error: 'isUploadCustomerItemPhotos is required' }).optional(),
    }),
    filters: zod_1.z.object({
        isCategory: zod_1.z.enum(['1', '2'], { required_error: 'isCategory is required' }).optional(),
        isProducts: zod_1.z.enum(['1', '2'], { required_error: 'IsProducts is required' }).optional(),
        isAttribute: zod_1.z.enum(['1', '2'], { required_error: 'isAttribute is required' }).optional()
    }).optional()
}).optional();
exports.categorySchema = zod_1.z.object({
    categoryTitle: zod_1.z.string({ required_error: 'Category title is required', }).min(2, 'Category title is should be 2 chars minimum'),
    description: zod_1.z.string().optional(),
    parentCategory: zod_1.z.string().optional(),
    categoryImageUrl: zod_1.z.string().optional(),
    categoryType: zod_1.z.string().optional(),
    categoryImage: zod_1.z.any({ required_error: 'Category image is required' }).nullable(),
    status: zod_1.z.string().optional(),
    serviceSettings: exports.serviceSettings,
    additionalFields: zod_1.z.any().optional(),
    slug: zod_1.z.any().optional(),
    level: zod_1.z.any().optional(),
}).nonstrict();
exports.categoryStatusSchema = zod_1.z.object({
    status: zod_1.z.string()
        .min(1, { message: "Status is required" })
        .max(1, { message: "Status must be a single character" })
        .refine(value => value === "1" || value === "2", {
        message: "Status must be either '1' or '2'"
    })
});
