"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.complaintSchema = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const zod_1 = require("zod");
exports.complaintSchema = zod_1.z.object({
    _id: zod_1.z.string().optional(),
    categoryId: zod_1.z.string().refine((id) => mongoose_1.default.Types.ObjectId.isValid(id), {
        message: 'Invalid category ID',
    }),
    complaintTitle: zod_1.z.string().min(1, { message: 'Item title is required.' }),
    description: zod_1.z.string().optional(),
    slug: zod_1.z.string().min(3, { message: 'Slug must be at least 3 characters long.' }).optional(),
    status: zod_1.z.enum(['1', '2', '3']).optional(),
});
