"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.warrantySchema = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const zod_1 = require("zod");
const collections_1 = require("../../../../constants/collections");
exports.warrantySchema = zod_1.z.object({
    warrantyTitle: zod_1.z.string().min(3, { message: "Warranty title must be at least 3 characters long." })
        .refine(async (value) => {
        const count = await mongoose_1.default.model(collections_1.collections.inventoryManagement.warranty).countDocuments({ warrantyTitle: value });
        return count === 0;
    }, {
        message: "Warranty title must be unique.",
    }),
    slug: zod_1.z.string().min(3, { message: "Slug must be at least 3 characters long." })
        .refine(async (value) => {
        const count = await mongoose_1.default.model(collections_1.collections.inventoryManagement.warranty).countDocuments({ slug: value });
        return count === 0;
    }, {
        message: "Slug must be unique.",
    }),
    warrantyCode: zod_1.z.string().min(3, { message: "Warranty code must be at least 3 characters long." })
        .refine(async (value) => {
        const count = await mongoose_1.default.model(collections_1.collections.inventoryManagement.warranty).countDocuments({ warrantyCode: value });
        return count === 0;
    }, {
        message: "Warranty code must be unique.",
    }),
    status: zod_1.z.enum(['1', '2']).default('1').optional(),
    warrantyPeriod: zod_1.z.object({
        years: zod_1.z.number().min(0, { message: "Years must be a positive number or zero." }).max(10, { message: "Years cannot exceed 10." }),
        months: zod_1.z.number().min(0, { message: "Months must be a positive number or zero." }).max(11, { message: "Months cannot exceed 11." }),
        days: zod_1.z.number().min(0, { message: "Days must be a positive number or zero." }).max(31, { message: "Days cannot exceed 31." }).default(0),
    }),
    termsAndConditions: zod_1.z.string().optional(),
    coverageDetails: zod_1.z.string().optional(),
});
