"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.manageByProductJobOrderSchema = exports.serviceTransferAssignDriverJobOrderSchema = exports.technicianAcceptStatusChangeJobOrderSchema = exports.serviceTransferBranchJobOrderSchema = exports.vendorAssignJobOrderSchema = exports.serviceStatusChangeJobOrderSchema = exports.spareRequestAndTransferJobOrderSchema = exports.addSpareJobOrderSchema = exports.assignTaskJobOrderSchema = exports.createJobOrderSchema = void 0;
const zod_1 = require("zod");
const job_order_1 = require("../../../../constants/admin/job-order");
exports.createJobOrderSchema = zod_1.z.object({
    jobOrderId: zod_1.z.string().optional(),
    createdBranchId: zod_1.z.string({
        required_error: 'Branch is required',
    }).min(2, 'Item master ID should be at least 2 characters long'),
    itemMasterId: zod_1.z.string({
        required_error: 'Item master ID is required',
    }).min(2, 'Item master ID should be at least 2 characters long'),
    categoryId: zod_1.z.string({
        required_error: 'Category ID is required',
    }).min(2, 'Category ID should be at least 2 characters long'),
    parentCategoryId: zod_1.z.string({
        required_error: 'ParentCategory is required',
    }).min(2, 'Category ID should be at least 2 characters long'),
    customerId: zod_1.z.string({
        required_error: 'Customer ID is required',
    }).min(2, 'Customer ID should be at least 2 characters long'),
    complaintId: zod_1.z.string({
        required_error: 'Complaint ID is required',
    }).min(2, 'Complaint ID should be at least 2 characters long'),
    vendorId: zod_1.z.string().optional(),
    conditionId: zod_1.z.string().optional(),
    paymentTermId: zod_1.z.string().optional(),
    costCenterId: zod_1.z.string().optional(),
    transferBranchId: zod_1.z.string().optional(),
    attributes: zod_1.z.array(zod_1.z.object({
        attributeId: zod_1.z.string({
            required_error: 'Attribute ID is required',
        }),
        attributeDetailId: zod_1.z.string({
            required_error: 'Attribute Detail ID is required',
        }),
    })).optional(),
    serialNumber: zod_1.z.string().optional(),
    customerComments: zod_1.z.string().optional(),
    remarks: zod_1.z.string().optional(),
    galleryImage: zod_1.z.any().optional(),
    customerIdGalleryImage: zod_1.z.any().optional(),
    selectedItemDetails: zod_1.z.array(zod_1.z.object({
        itemId: zod_1.z.string().min(1, 'item is required'),
        quantity: zod_1.z
            .string()
            .transform((val) => Number(val))
            .refine((val) => !isNaN(val), 'Quantity must be a valid number')
            .refine((val) => val >= 0, 'Quantity must be positive'),
        totalPrice: zod_1.z
            .string()
            .transform((val) => Number(val))
            .refine((val) => !isNaN(val), 'Item total price must be a valid number')
            .refine((val) => val >= 0, 'Item total price must be positive'),
        itemPrice: zod_1.z
            .string()
            .transform((val) => Number(val))
            .refine((val) => !isNaN(val), 'Item price must be a valid number')
            .refine((val) => val >= 0, 'Item price must be positive'),
        itemTypeQuantity: zod_1.z
            .string()
            .transform((val) => Number(val))
            .refine((val) => !isNaN(val), 'Item type quantity must be a valid number')
            .refine((val) => val >= 0, 'Item type quantity must be positive'),
        itemType: zod_1.z.string().min(1, 'item is required'),
    })).optional(),
    costItems: zod_1.z.array(zod_1.z.object({
        costTypeId: zod_1.z.string().min(1, 'Cost Type is required'),
        costType: zod_1.z.string().min(1, 'Cost Type is required'),
        operationType: zod_1.z.string().min(1, 'Operation Type is required'),
        costAmount: zod_1.z.union([zod_1.z.number().min(0, 'Amount must be positive'), zod_1.z.string().min(1)])
            .transform((val) => Number(val))
            .refine((val) => !isNaN(val), 'Received amount must be a valid number')
            .refine((val) => val >= 0, 'Received amount must be positive')
            .optional(),
    })).optional(),
    saleEmployees: zod_1.z.array(zod_1.z.object({
        saleEmployeeId: zod_1.z.string({
            required_error: 'Sale employee required',
        }).min(2, 'Select sale employee'),
    })).nonempty('At least one assign staff is required'),
    assignmentHistory: zod_1.z.array(zod_1.z.object({
        technicianId: zod_1.z.string(),
    })).optional(),
    customerSignature: zod_1.z.string().optional(),
    totalAmount: zod_1.z.string()
        .transform((val) => parseFloat(val))
        .refine((val) => !isNaN(val) && val >= 0, 'Total amount must be a positive number or zero'),
    balanceAmount: zod_1.z.string()
        .transform((val) => parseFloat(val))
        .refine((val) => !isNaN(val), 'Balance amount must be a number'),
    subtotalAmount: zod_1.z.string()
        .transform((val) => parseFloat(val))
        .refine((val) => !isNaN(val) && val >= 0, 'Subtotal amount must be a positive number or zero'),
    serviceType: zod_1.z.string().optional(),
    dueDate: zod_1.z.string()
        .optional()
        .refine(value => {
        if (!value)
            return true;
        const date = new Date(value);
        return !isNaN(date.getTime());
    }, {
        message: "Expected Delivery Date and Time must be a valid date",
    })
        .transform(value => value ? new Date(value) : undefined),
    additionalFields: zod_1.z.any().optional(),
}).superRefine((data, ctx) => {
    if (data.balanceAmount < 0 && data.totalAmount < Math.abs(data.balanceAmount)) {
        ctx.addIssue({
            code: zod_1.ZodIssueCode.custom,
            path: ['totalAmount'],
            message: 'Total amount must be greater than or equal to the absolute value of balance amount when balance is negative',
        });
    }
});
exports.assignTaskJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    taskId: zod_1.z.string().optional(),
    taskTitle: zod_1.z.string({
        required_error: 'Task Title is required',
    }).min(2, 'Task Title should be at least 2 characters long'),
    technicianStatus: zod_1.z.string({
        required_error: 'Technician Status is required',
    }).min(2, 'Technician Status should be at least 2 characters long'),
    description: zod_1.z.string().optional(),
    assignmentHistory: zod_1.z.array(zod_1.z.object({
        taskId: zod_1.z.string().optional(),
        technicianId: zod_1.z.string({
            required_error: 'Technician ID is required',
        }).min(1, 'Technician ID should not be empty'),
    })).nonempty('At least one assign staff is required'),
    startDate: zod_1.z.string({
        required_error: 'Start date is required',
    }).refine((value) => {
        const date = new Date(value);
        return !isNaN(date.getTime()); // Checks if valid date
    }, 'Invalid start date'),
    endDate: zod_1.z.string({
        required_error: 'Start date is required',
    }).refine((value) => {
        const date = new Date(value);
        return !isNaN(date.getTime()); // Checks if valid date
    }, 'Invalid start date'),
    priority: zod_1.z.string().optional(),
    taskStartTime: zod_1.z.any().optional(),
    taskEndTime: zod_1.z.any().optional(),
    reassignedFromId: zod_1.z.string().optional(),
    reason: zod_1.z.string().optional(),
});
exports.addSpareJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    itemMasterId: zod_1.z.string({
        required_error: 'Item Master ID is required',
    }).min(2, 'Item Master ID should be at least 2 characters long'),
    technicianId: zod_1.z.string({
        required_error: 'Technician ID is required',
    }).min(1, 'Technician ID should not be empty'),
    selectedItemDetails: zod_1.z.array(zod_1.z.object({
        usedItemId: zod_1.z.string().optional(),
        itemId: zod_1.z.string({
            required_error: 'Item ID is required',
        }).min(1, 'Item ID should not be empty'),
        quantity: zod_1.z
            .number({
            required_error: 'Quantity is required',
        })
            .min(1, 'Quantity must not be empty')
            .transform((value) => Number(value))
            .refine((val) => !isNaN(val) && val > 0, {
            message: 'Quantity must be a valid positive number',
        }),
        buyedItemPrice: zod_1.z
            .number({
            required_error: 'Price is required',
        })
            .min(1, 'Price must not be empty')
            .transform((value) => Number(value))
            .refine((val) => !isNaN(val) && val > 0, {
            message: 'Price must be a valid positive number',
        }),
        itemPrice: zod_1.z
            .number({
            required_error: 'Price is required',
        })
            .min(1, 'Price must not be empty')
            .transform((value) => Number(value))
            .refine((val) => !isNaN(val) && val > 0, {
            message: 'Price must be a valid positive number',
        })
    })).nonempty('At least one item must be selected'),
});
exports.spareRequestAndTransferJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    itemMasterId: zod_1.z.string({
        required_error: 'Item Master ID is required',
    }).min(2, 'Item Master ID should be at least 2 characters long'),
    itemId: zod_1.z.string({
        required_error: 'Item ID is required',
    }).min(2, 'Item ID should be at least 2 characters long'),
    currentBranchId: zod_1.z.string({
        required_error: 'Current branch ID is required',
    }).min(2, 'Current branch ID should be at least 2 characters long'),
    newBranchId: zod_1.z.string({
        required_error: 'New branch ID is required',
    }).min(2, 'New branch ID should be at least 2 characters long'),
    transferredBy: zod_1.z.string().optional(),
    quantity: zod_1.z
        .number()
        .transform((val) => Number(val))
        .refine((val) => !isNaN(val), 'Quantity must be a valid number')
        .refine((val) => val >= 0, 'Quantity must be positive'),
    requestedBy: zod_1.z.string().optional(),
    type: zod_1.z.string({
        required_error: 'type is required',
    }).min(2, 'type should be at least 2 characters long'),
    reason: zod_1.z.string().optional(),
    remarks: zod_1.z.string().optional(),
    priority: zod_1.z.string().optional(),
}).superRefine((data, ctx) => {
    const { type, transferredBy, requestedBy } = data;
    if (type === job_order_1.spareRequestAndTransferJson.request && (!requestedBy || requestedBy.length < 1)) {
        ctx.addIssue({
            code: zod_1.z.ZodIssueCode.custom,
            path: ['requestedBy'],
            message: 'Requested by is required and should be at least 1 characters long for requests.',
        });
    }
    if (type === job_order_1.spareRequestAndTransferJson.transfer && (!transferredBy || transferredBy.length < 1)) {
        ctx.addIssue({
            code: zod_1.z.ZodIssueCode.custom,
            path: ['transferredBy'],
            message: 'Transferred by is required and should be at least 1 characters long for transfers.',
        });
    }
});
exports.serviceStatusChangeJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    serviceStatus: zod_1.z.string({
        required_error: 'Vendor status is required',
    }).min(2, 'Vendor status should be at least 2 characters long'),
    serviceStatusMessage: zod_1.z.string({
        required_error: 'Service status message is required',
    }).min(2, 'Service status message should be at least 2 characters long'),
});
exports.vendorAssignJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    vendorId: zod_1.z.string({
        required_error: 'Vendor is required',
    }).min(2, 'Vendor should be at least 2 characters long'),
    vendorStatus: zod_1.z.string({
        required_error: 'Vendor status is required',
    }).min(2, 'Vendor status should be at least 2 characters long'),
    vendorNotes: zod_1.z.string().optional(),
    vendorAssignRemarks: zod_1.z.string().optional(),
});
exports.serviceTransferBranchJobOrderSchema = zod_1.z.object({
    orderMasterId: zod_1.z.string({
        required_error: 'Order master ID is required',
    }).min(2, 'Order master ID should be at least 2 characters long'),
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    transferBranchId: zod_1.z.string().optional(),
    currentBranchId: zod_1.z.string({
        required_error: 'Current branch is required',
    }).min(2, 'Current branch should be at least 2 characters long'),
    transferBranchStatus: zod_1.z.string().optional(),
    transferNotes: zod_1.z.string().optional(),
    driverId: zod_1.z.string().optional(),
    driverHistoryStatus: zod_1.z.string().optional(),
    serviceStatusMessage: zod_1.z.string({
        required_error: 'Service status message is required',
    }).min(2, 'Service status message should be at least 2 characters long'),
});
exports.technicianAcceptStatusChangeJobOrderSchema = zod_1.z.object({
    taskId: zod_1.z.string({
        required_error: 'Order master ID is required',
    }).min(2, 'Order master ID should be at least 2 characters long'),
    orderMasterId: zod_1.z.string({
        required_error: 'Order master ID is required',
    }).min(2, 'Order master ID should be at least 2 characters long'),
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    technicianStatus: zod_1.z.string({
        required_error: ' Technician status is required',
    }).min(2, ' Technician status should be at least 2 characters long'),
});
exports.serviceTransferAssignDriverJobOrderSchema = zod_1.z.object({
    orderMasterId: zod_1.z.string({
        required_error: 'Order master ID is required',
    }).min(2, 'Order master ID should be at least 2 characters long'),
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    currentBranchId: zod_1.z.string({
        required_error: 'Current branch is required',
    }).min(2, 'Current branch should be at least 2 characters long'),
    driverId: zod_1.z.string({
        required_error: 'Driver is required',
    }).min(2, 'Driver should be at least 2 characters long'),
    driverHistoryStatus: zod_1.z.string({
        required_error: 'Status is required',
    }).min(2, 'Status should be at least 2 characters long'),
    transferNotes: zod_1.z.string().optional(),
});
exports.manageByProductJobOrderSchema = zod_1.z.object({
    orderDetailId: zod_1.z.string({
        required_error: 'Order detail ID is required',
    }).min(2, 'Order detail ID should be at least 2 characters long'),
    itemMasterId: zod_1.z.string({
        required_error: 'Item Master ID is required',
    }).min(2, 'Item Master ID should be at least 2 characters long'),
    selectedItemDetails: zod_1.z.array(zod_1.z.object({
        byProductId: zod_1.z.string().optional(),
        itemId: zod_1.z.string({
            required_error: 'Item ID is required',
        }).min(1, 'Item ID should not be empty'),
        quantity: zod_1.z
            .number({
            required_error: 'Quantity is required',
        })
            .min(1, 'Quantity must not be empty')
            .transform((value) => Number(value))
            .refine((val) => !isNaN(val) && val > 0, {
            message: 'Quantity must be a valid positive number',
        }),
    })).nonempty('At least one item must be selected'),
});
