"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.costCenterSchema = exports.paymentTermsSchema = void 0;
const zod_1 = require("zod");
exports.paymentTermsSchema = zod_1.z.object({
    paymentTermsId: zod_1.z.string().optional(),
    paymentTitle: zod_1.z.string({ required_error: 'Payment title is required', }).min(2, 'Payment title is should be 2 chars minimum'),
    // effectOnTotal: zod.enum([effectOnTotals.add, effectOnTotals.subtract], {
    //     required_error: 'Effect on total is required',
    // }),
    // amount: zod.number().optional().transform((val) => Number(val)).refine((val) => !isNaN(val), 'Amount must be a valid number').refine((val) => val >= 0, 'Amount must be positive'),
});
exports.costCenterSchema = zod_1.z.object({
    costId: zod_1.z.string().optional(),
    costTitle: zod_1.z.string({ required_error: 'Payment title is required', }).min(2, 'Payment title is should be 2 chars minimum'),
});
