"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.additionalCostValuesSchema = void 0;
const zod_1 = require("zod");
const other_1 = require("../../../../constants/admin/other");
exports.additionalCostValuesSchema = zod_1.z.object({
    _id: zod_1.z.string().optional(),
    costValueTitle: zod_1.z.string().min(1, { message: 'cost value title is required.' }),
    operationType: zod_1.z.enum([other_1.operationTypes.add, other_1.operationTypes.subtract], { required_error: 'Customer type is required' }).default(other_1.operationTypes.add),
    defaultValue: zod_1.z
        .number()
        .transform((val) => Number(val))
        .refine((val) => !isNaN(val), 'Default value must be a valid number')
        .refine((val) => val >= 0, 'Default value must be positive'),
    slug: zod_1.z.string().optional(),
    status: zod_1.z.enum(['1', '2', '3']).optional(),
});
