"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.customerOtherServiceDetailsSchema = void 0;
const mongoose_1 = __importDefault(require("mongoose"));
const zod_1 = require("zod");
const objectIdSchema = zod_1.z
    .string()
    .refine((val) => mongoose_1.default.Types.ObjectId.isValid(val), {
    message: 'Invalid MongoDB ObjectId',
});
const serviceDetailItemSchema = zod_1.z.object({
    key: zod_1.z.string().min(1),
    value: zod_1.z.any(),
});
const serviceDetailValuesSchema = zod_1.z.object({
    categoryId: objectIdSchema,
    data: zod_1.z.array(serviceDetailItemSchema),
});
exports.customerOtherServiceDetailsSchema = zod_1.z.object({
    customerOtherServiceDetailsTitle: zod_1.z.string().min(1),
    slug: zod_1.z.string().optional(),
    categoryId: zod_1.z.string({ required_error: 'Category id is required', }).min(2, 'Category id is should be 2 chars minimum'),
    itemValue: zod_1.z.string({ required_error: 'Item is required', }).min(2, 'Item is should be 2 chars minimum'),
    status: zod_1.z.enum(['1', '2', '3']).optional(),
});
