"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.settingSchema = void 0;
const zod_1 = require("zod");
exports.settingSchema = zod_1.z.object({
    _id: zod_1.z.string().optional(),
    settingTitle: zod_1.z.string().min(1, { message: 'Setting title is required.' }),
    settingType: zod_1.z.string().min(1, { message: 'Setting type is required.' }),
    settingValues: zod_1.z.any(),
    slug: zod_1.z.string().optional(),
    status: zod_1.z.enum(['1', '2', '3']).optional(),
});
