"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.designationSchema = void 0;
const zod_1 = require("zod");
exports.designationSchema = zod_1.z.object({
    designationTitle: zod_1.z.string({ required_error: 'Designation title is required', }).min(2, 'Designation title is should be 2 chars minimum'),
    designationCode: zod_1.z.string({ required_error: 'Designation code required', }).min(3, 'Designation code is should be 3 chars minimum'),
}).nonstrict();
