"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.userSchema = void 0;
const zod_1 = require("zod");
exports.userSchema = zod_1.z.object({
    countryId: zod_1.z.string().optional(),
    stateId: zod_1.z.string().optional(),
    cityId: zod_1.z.string().optional(),
    designationCode: zod_1.z.string({ required_error: 'Designation code required', }).min(3, 'Designation code is should be 3 chars minimum'),
    branchCode: zod_1.z.string({ required_error: 'Branch code required', }).min(3, 'Branch code is should be 3 chars minimum'),
    departmentCode: zod_1.z.string({ required_error: 'Department code required', }).min(3, 'Department code is should be 3 chars minimum'),
    userCode: zod_1.z.string({ required_error: 'User code is required', }).min(3, 'User code is should be 3 chars minimum'),
    userTitle: zod_1.z.string({ required_error: 'User name is required', }).min(3, 'User name is should be 3 chars minimum'),
    userEmail: zod_1.z.string({ required_error: 'Email is required', }).email('Please provide a valid email address'),
    userPhoneNumber: zod_1.z.string()
        .regex(/^\d{9,}$/, 'Phone number should contain only numbers and be at least 9 digits long'),
    userPassword: zod_1.z.string({ required_error: 'Phone number is required' }).min(6, 'Password too short - should be 6 chars minimum'),
}).nonstrict();
