"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.vendorSchema = void 0;
const zod_1 = require("zod");
exports.vendorSchema = zod_1.z.object({
    vendorTitle: zod_1.z.string({
        required_error: 'Vendor title is required',
    }).min(2, 'Vendor title should be at least 2 characters long'),
    vendorCode: zod_1.z.string({
        required_error: 'Vendor code is required',
    }).min(2, 'Vendor code should be at least 2 characters long'),
    contactName: zod_1.z.string().optional(),
    contactEmail: zod_1.z.string().email('Invalid email format').optional(),
    contactPhone: zod_1.z.string().optional(),
    address: zod_1.z.string().optional(),
    city: zod_1.z.string().optional(),
    country: zod_1.z.string().optional(),
    postalCode: zod_1.z.string().optional(),
    vendorType: zod_1.z.string({
        required_error: 'Vendor type is required',
    }).optional(),
    notes: zod_1.z.string().optional(),
    status: zod_1.z.string({
        required_error: 'Status is required',
    }).optional(),
    createdBy: zod_1.z.string().optional(),
    createdAt: zod_1.z.date().optional(),
    updatedAt: zod_1.z.date().optional(),
});
